unit Bsfolbl;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TCMMouseEnter = record
    Msg : Cardinal;
    Unused : Integer;
    Sender : TControl;
    Result : LongInt;
  end;
  TCMMouseLeave = TCMMouseEnter;
  TBSFOLabel = class(TLabel)
  private
    { Private declarations }
    FOldColor : TColor;
    FFlyOverColor : TColor;
    FOnMouseEnter : TNotifyEvent;
    FOnMouseLeave : TNotifyEvent;
    procedure CMMouseEnter(var Msg : TCMMouseEnter); message CM_MouseEnter;
    procedure CMMouseLeave(var Msg : TCMMouseLeave); message CM_MouseLeave;
  protected
    { Protected declarations }
  public
    { Public declarations }
    Constructor Create(AOwner : TComponent); override;
  published
    { Published declarations }
    property FlyOverColor : TColor read FFlyOverColor write FFlyOverColor;
    property OnMouseEnter : TNotifyEvent read FOnMouseEnter write FOnMouseEnter;
    property OnMouseLeave : TNotifyEvent read FOnMouseLeave write FOnMouseLeave;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TBSFOLabel]);
end;

Constructor TBSFOLabel.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);
  FFlyOverColor := Font.Color;
end;

procedure TBSFOLabel.CMMouseEnter(var Msg : TCMMouseEnter);
begin
  inherited;
  if Assigned(FOnMouseEnter) then
    FOnMouseEnter(Self);
  if Msg.Sender = nil then begin
    FOldColor := Font.Color;
    Font.Color := FFlyOverColor;
  end;
end;

procedure TBSFOLabel.CMMouseLeave(var Msg : TCMMouseLeave);
begin
  inherited;
  if Assigned(FOnMouseLeave) then
    FOnMouseLeave(Self);
  if Msg.Sender = nil then
    Font.Color := FOldColor;
end;


end.
